(function(window,document,undefined){var absPos=function(element){var offsetLeft,offsetTop;offsetLeft=offsetTop=0;if(element.offsetParent)do offsetLeft+=element.offsetLeft,offsetTop+=element.offsetTop;while(element=element.offsetParent);return[offsetLeft,offsetTop]},ProgressCircle=function(params){this.canvas=params.canvas,this.minRadius=params.minRadius||15,this.arcWidth=params.arcWidth||5,this.gapWidth=params.gapWidth||3,this.centerX=params.centerX||this.canvas.width/2,this.centerY=params.centerY||this.canvas.height/2,this.infoLineLength=params.infoLineLength||60,this.horizLineLength=params.horizLineLength||10,this.infoLineAngleInterval=params.infoLineAngleInterval||Math.PI/8,this.infoLineBaseAngle=params.infoLineBaseAngle||Math.PI/6,this.context=this.canvas.getContext("2d"),this.width=this.canvas.width,this.height=this.canvas.height,this.circles=[],this.runningCount=0};ProgressCircle.prototype={constructor:ProgressCircle,addEntry:function(params){return this.circles.push(new Circle({canvas:this.canvas,context:this.context,centerX:this.centerX,centerY:this.centerY,innerRadius:this.minRadius+this.circles.length*(this.gapWidth+this.arcWidth),arcWidth:this.arcWidth,infoLineLength:this.infoLineLength,horizLineLength:this.horizLineLength,id:this.circles.length,fillColor:params.fillColor,outlineColor:params.outlineColor,progressListener:params.progressListener,infoListener:params.infoListener,infoLineAngle:this.infoLineBaseAngle+this.circles.length*this.infoLineAngleInterval})),this},start:function(interval){var self=this;return this.timer=setInterval(function(){self._update()},interval||33),this},stop:function(){clearTimeout(this.timer)},_update:function(){return this._clear(),this.circles.forEach(function(circle,idx,array){circle.update()}),this},_clear:function(){return this.context.clearRect(0,0,this.canvas.width,this.canvas.height),this}};var Circle=function(params){this.id=params.id,this.canvas=params.canvas,this.context=params.context,this.centerX=params.centerX,this.centerY=params.centerY,this.arcWidth=params.arcWidth,this.innerRadius=params.innerRadius||0,this.fillColor=params.fillColor||"#fff",this.outlineColor=params.outlineColor||this.fillColor,this.progressListener=params.progressListener,this.infoLineLength=params.infoLineLength||250,this.horizLineLength=params.horizLineLength||50,this.infoListener=params.infoListener,this.infoLineAngle=params.infoLineAngle,this.outerRadius=this.innerRadius+this.arcWidth;if(!this.infoListener)return;var angle=this.infoLineAngle,arcDistance=(this.innerRadius+this.outerRadius)/2,sinA=Math.sin(angle),cosA=Math.cos(angle);this.infoLineStartX=this.centerX+sinA*arcDistance,this.infoLineStartY=this.centerY-cosA*arcDistance,this.infoLineMidX=this.centerX+sinA*this.infoLineLength,this.infoLineMidY=this.centerY-cosA*this.infoLineLength,this.infoLineEndX=this.infoLineMidX+(sinA<0?-this.horizLineLength:this.horizLineLength),this.infoLineEndY=this.infoLineMidY;var infoText=document.createElement("div"),style=infoText.style;style.color=this.fillColor,style.position="absolute",style.left=this.infoLineEndX+absPos(this.canvas)[0]+"px",infoText.className="ProgressCircleInfo",infoText.id="progress_circle_info_"+this.id,document.body.appendChild(infoText),this.infoText=infoText};Circle.prototype={constructor:Circle,update:function(){this.progress=this.progressListener(),this._draw(),this.infoListener&&(this.info=this.infoListener(),this._drawInfo())},_draw:function(){var ctx=this.context,ANGLE_OFFSET=-Math.PI/2,startAngle=0+ANGLE_OFFSET,endAngle=startAngle+this.progress*Math.PI*2,x=this.centerX,y=this.centerY,innerRadius=this.innerRadius-this.arcWidth-1,outerRadius=this.outerRadius-this.arcWidth-1;if(innerRadius<0)return;return ctx.fillStyle=this.fillColor,ctx.strokeStyle=this.outlineColor,ctx.beginPath(),ctx.arc(x,y,innerRadius,startAngle,endAngle,!1),ctx.arc(x,y,outerRadius,endAngle,startAngle,!0),ctx.closePath(),ctx.stroke(),ctx.fill(),this},_drawInfo:function(){var pointList,lineHeight;return pointList=[[this.infoLineStartX,this.infoLineStartY],[this.infoLineMidX,this.infoLineMidY],[this.infoLineEndX,this.infoLineEndY]],this._drawSegments(pointList,!1),this.infoText.innerHTML=this.info,lineHeight=this.infoText.offsetHeight,this.infoText.style.top=this.infoLineEndY+absPos(this.canvas)[1]-lineHeight/2+"px",this},_drawSegments:function(pointList,close){var ctx=this.context;ctx.beginPath(),ctx.moveTo(pointList[0][0],pointList[0][1]);for(var i=1;i<pointList.length;++i)ctx.lineTo(pointList[i][0],pointList[i][1]);close&&ctx.closePath(),ctx.stroke()}},window.ProgressCircle=ProgressCircle})(window,document),function($){var VcChart=function(element,options){this.el=element,this.$el=$(this.el);var $this=this;$this.options=$.extend({color:"wpb_button",units:"",width:"",label_selector:".vc_pie_chart_value",back_selector:".vc_pie_chart_back",responsive:!0},options),$this.init()};VcChart.prototype={constructor:VcChart,_progress_v:0,animated:!1,colors:{wpb_button:"rgba(247, 247, 247, 1)","btn-primary":"rgba(0, 136, 204, 1)","btn-info":"rgba(88, 185, 218, 1)","btn-success":"rgba(106, 177, 101, 1)","btn-warning":"rgba(255, 153, 0, 1)","btn-danger":"rgba(255, 103, 91, 1)","btn-inverse":"rgba(85, 85, 85, 1)"},init:function(){this.setupColor(),this.value=this.$el.data("pie-value")/100,this.label_value=this.$el.data("pie-label-value")||this.$el.data("pie-value"),this.$wrapper=$(".vc_pie_wrapper",this.$el),this.$label=$(this.options.label_selector,this.$el),this.$back=$(this.options.back_selector,this.$el),this.$canvas=this.$el.find("canvas"),this.arcWidth=this.$el.data("pie-width")*2,this.draw(),this.setWayPoint(),this.options.responsive===!0&&this.setResponsive(),UNCODE.isMobile&&(this._progress_v=this.value)},setupColor:function(){typeof this.options.color!="undefined"?this.color=this.options.color:this.color="rgba(247, 247, 247, 0.2)"},setResponsive:function(){var that=this;UNCODE.isMobile||$(window).resize(function(){that.animated===!0&&that.circle.stop(),that.draw(!0)})},draw:function(redraw){var w=this.$el.addClass("vc_ready").width()*2,border_w=this.arcWidth,radius;w||(w=this.$el.parents(":visible").first().width()-2),radius=w/2,this.$wrapper.css({width:w/2+"px"}),this.$label.css({width:w/2,height:w/2,"line-height":w/2+"px"}),this.$back.css({width:w/2,height:w/2}),this.$canvas.attr({width:w+"px",height:w+"px"}),this.$el.addClass("vc_ready"),this.circle=new ProgressCircle({canvas:this.$canvas.get(0),minRadius:radius,arcWidth:border_w}),redraw===!0&&this.animated===!0&&(this._progress_v=this.value,this.circle.addEntry({fillColor:this.color,progressListener:$.proxy(this.setProgress,this)}).start())},setProgress:function(){if(this._progress_v>=this.value)return this.circle.stop(),this.animated=!0,this.$label.html(this.label_value+this.options.units),this._progress_v;this._progress_v+=.01;if(!isNaN(this.label_value)){var label_value=this._progress_v/this.value*this.label_value,val=Math.round(label_value)+this.options.units;this.$label.html(val)}else this.$label.html(this.label_value+this.options.units);return this._progress_v},animate:function(){this.animated!==!0&&this.circle.addEntry({fillColor:this.color,progressListener:$.proxy(this.setProgress,this)}).start(10)},setWayPoint:function(){typeof $.fn.waypoint!="undefined"&&!UNCODE.isMobile?this.$el.waypoint($.proxy(this.animate,this),{offset:"85%"}):this.animate()}},$.fn.vcChat=function(option,value){return this.each(function(){var $this=$(this),data=$this.data("vc_chart"),options=typeof option=="object"?option:{color:$this.data("pie-color"),units:$this.data("pie-units")};typeof option=="undefined"&&$this.data("vc_chart",data=new VcChart(this,options)),typeof option=="string"&&data[option](value)})},typeof window["vc_pieChart"]!="function"&&(window.vc_pieChart=function(){$(".vc_pie_chart:visible:not(.vc_ready)").vcChat()}),$(document).ready(function(){!window.vc_iframe&&vc_pieChart(),$(".nav-tabs a").on("shown.bs.tab",function(e){var $cont=$(e.target).closest(".tab-container"),$active=$(".tab-pane.active",$cont);$(".vc_pie_chart:not(.vc_ready)",$active).vcChat()}),$(".panel-collapse").on("shown.bs.collapse",function(e){$(".vc_pie_chart:not(.vc_ready)",e.target).vcChat()})})}(window.jQuery)